<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Attrs\Style\Props\FormMethod;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\Entity\ChatArchivesEntity;
use model\Entity\ChatMessagesEntity;
use model\Entity\ChatsEntity;
use model\Entity\UsersEntity;
use model\Entity\UsersTableEntity;
use model\UsersTable;
use View;

class Chats extends View
{

    public $SingularName = 'چت';

    public function main(Document &$document)
    {

        $document->html = HtmlTags::Section('.content.mt-1')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-3')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline.direct-chat.direct-chat-primary')->Content(
                                    HtmlTags::Div('.card-header')->Content(
                                        HtmlTags::H3('.card-title')->Content(
                                            'مخاطبین'
                                        )
                                    ),
                                    HtmlTags::Div('.card-body')->Content(
                                        HtmlTags::Div('.direct-chat-contacts')->Content(
                                            HtmlTags::Ul('.contacts-list')->Content(
                                                HtmlTags::Input('.form-control.w-100.m-1#chatSearch')->PlaceHolder("جستجو..."),

                                                function () {
                                                    $output = [];
                                                    /** @var UserObject $userObject */
                                                    $userObject = UserObject::instance();
                                                    if ($userObject instanceof UserObject) {
                                                        /** @var ChatsEntity $chat */
                                                        switch ($userObject->getRole()) {
                                                            case "OperatorRole":
                                                                $chats = \model\Chats::getAllFiltered('operator_id', $userObject->getUserId());
                                                                $chats = $chats->sortBy(function (ChatsEntity $chat) {
                                                                    return ($chat->lastMessage() instanceof ChatMessagesEntity ? strtotime($chat->lastMessage()->created_at) : 0);
                                                                }, true);
                                                                break;
                                                            case "SupervisorRole":
                                                                $operators = UsersTable::getAllFiltered('supervisor_id', $userObject->getUserId())->map(function (UsersTableEntity $usersTableEntity) {
                                                                    return $usersTableEntity->user_id;
                                                                })->all();
                                                                $tmpChats = \model\Chats::Db()->whereIn('operator_id', $operators)->get();
                                                                $chats = [];
                                                                foreach ($tmpChats as $chat) {
                                                                    if (!is_array($chats["operator_$chat->operator_id"])) {
                                                                        $chats["operator_$chat->operator_id"] = [];
                                                                    }
                                                                    $chats["operator_$chat->operator_id"][] = $chat;
                                                                }
                                                                break;
                                                            case "AdminRole":
                                                            default:
                                                                $tmpChats = \model\Chats::getAll();
                                                                $chats = [];
                                                                foreach ($tmpChats as $chat) {
                                                                    if (!is_array($chats["operator_$chat->operator_id"])) {
                                                                        $chats["operator_$chat->operator_id"] = [];
                                                                    }
                                                                    $chats["operator_$chat->operator_id"][] = $chat;
                                                                }

                                                                break;
                                                        }
                                                        $operatorOptions = [];
                                                        foreach ($chats as $operatorId => $ch) {
                                                            if (str($operatorId)->includes('operator_')) {
                                                                /** @var UsersTableEntity $usertable */
                                                                $operatorId = collect(str($operatorId)->explode('_'))->last;
                                                                $usertable = UsersTable::get($operatorId);
                                                                $ch = collect($ch)->sortBy(function (ChatsEntity $chat) {
                                                                    return ($chat->lastMessage() instanceof ChatMessagesEntity ? strtotime($chat->lastMessage()->created_at) : 0);
                                                                }, true);
                                                                $output[] = HtmlTags::Li(".chat-operator.mb-4.mt-1#chat_operator_$operatorId")->Data_('id', $operatorId)->Content(
                                                                    HtmlTags::Label()->Attrs(['style' => 'color: black;'])->Content(
                                                                        $usertable->user_name ?? "اپراتور شماره {$operatorId}"
                                                                    ),
                                                                    HtmlTags::Ul('.contacts-list')->Content(
                                                                        function () use ($ch) {
                                                                            $output = [];
                                                                            foreach ($ch as $chat) {
                                                                                $user = $chat->user();
                                                                                if ($user instanceof UsersEntity) {
                                                                                    $output[] = HtmlTags::Li()->Content(
                                                                                        HtmlTags::A('.chat-contact')->Data_('id', $chat->chat_id)->Href('#')->Content(
                                                                                            HtmlTags::Img('.contacts-list-img')->Src($user->image()),
                                                                                            HtmlTags::Div('.contacts-list-info')->Content(
                                                                                                HtmlTags::Span('.contacts-list-name')->Content(
                                                                                                    HtmlTags::Span('.contact-list-name-inner')->Data_('number', $chat->order_id)->Content(
                                                                                                        $user->firstname . ' ' . $user->lastname . ' - شماره پرونده: ' . $chat->order_id . ' ',
                                                                                                    ),

                                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("Y/m/d", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                                    ),
                                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("H:i", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                                    ),
                                                                                                ),


                                                                                                HtmlTags::Div('.w-100.d-flex.flex-wrap.space-between')
                                                                                                    ->Attrs(['style' => 'justify-content:   space-between'])->Content(
                                                                                                        HtmlTags::Span('.contacts-list-msg.mt-1')->Content(
                                                                                                            en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? $chat->lastMessage()->htmlPreview() : "")
                                                                                                        ),
                                                                                                        HtmlTags::Span('.contacts-list-count.mt-1')->Content(
                                                                                                            en_to_fa($chat->unreadCount())
                                                                                                        ),
                                                                                                    )
                                                                                            )
                                                                                        )
                                                                                    );
                                                                                }
                                                                            }
                                                                            return implode('', $output);
                                                                        }
                                                                    )
                                                                );
                                                                $operatorOptions[] = $usertable instanceof UsersTableEntity
                                                                    ? $usertable->toOption()
                                                                    : HtmlTags::Option()->Value($operatorId)->Content(
                                                                        "اپراتور شماره $operatorId"
                                                                    );
                                                            } else {
                                                                $chat = $ch;
                                                                if ($chat instanceof ChatsEntity) {
                                                                    $output[] = HtmlTags::Li()->Content(
                                                                        HtmlTags::A(".chat-contact")->Data_('id', $chat->chat_id)->Href('#')->Content(
                                                                            HtmlTags::Img('.contacts-list-img')->Src($user->image()),
                                                                            HtmlTags::Div('.contacts-list-info')->Content(
                                                                                HtmlTags::Span('.contacts-list-name')->Content(
                                                                                    HtmlTags::Span('.contact-list-name-inner')->Data_('number', $chat->order_id)->Content(
                                                                                        $user->firstname . ' ' . $user->lastname . ' - شماره پرونده: ' . $chat->order_id . ' ',
                                                                                    ),

                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("Y/m/d", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                    ),
                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("H:i", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                    ),
                                                                                ),

                                                                                HtmlTags::Div('.w-100.d-flex.flex-wrap.space-between')
                                                                                    ->Attrs(['style' => 'justify-content:   space-between'])->Content(
                                                                                        HtmlTags::Span('.contacts-list-msg.mt-1')->Content(
                                                                                            en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? $chat->lastMessage()->htmlPreview() : "")
                                                                                        ),
                                                                                        HtmlTags::Span('.contacts-list-count.mt-1')->Content(
                                                                                            en_to_fa($chat->unreadCount())
                                                                                        ),
                                                                                    )

                                                                            )
                                                                        )
                                                                    );
                                                                }
                                                            }
                                                        }
                                                        array_unshift($output, HtmlTags::Select('.form-control.w-100.m-1')->Id('chatOperatorId')->Content(
                                                            HtmlTags::Option()->Value('all')->Content("همه"),
                                                            implode('', $operatorOptions)
                                                        ));
                                                        return implode('', $output);
                                                    } else {
                                                        echo "<script>window.location.href = '/admin/login'</script>";
                                                        return '';
                                                    }
                                                }
                                            )
                                        )
                                    )
                                )
                            ),
                            HtmlTags::Div('.col-md-9')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline.direct-chat.direct-chat-primary')->Content(
                                    HtmlTags::Div('.card-header')->Content(
                                        HtmlTags::H3('.card-title#cardTitle')->Content(
                                            'چت'
                                        ),
                                        HtmlTags::P('.card-text.mt-1#cardTitle')->Content(
                                            'برای ارسال فایل، فایل مورد نظر خود را در محدوده مشخص شده رها کنید'
                                        ),
                                        HtmlTags::Div('.card-tools')->Content(
                                            HtmlTags::Button('.btn.btn-danger.p-2#archiveChat')->Content(
                                                HtmlTags::I()->Class(FontAwesome::Archive()),
                                                HtmlTags::Span('.mr-2')->Content(
                                                    "آرشیو کردن"
                                                )
                                            )
                                        )
                                    ),
                                    HtmlTags::Div('.card-body')->Content(
                                        HtmlTags::Div('.direct-chat-messages#chat_content')->Content(),
                                    ),
                                    HtmlTags::Div('.card-footer#card_footer')->Attrs(['style' => 'display: none'])->Content(
                                        HtmlTags::Form("#message_form")->Action('#')->Method(FormMethod::Post())->Content(
                                            HtmlTags::Input()->Type('hidden')->Name('chatId')->Id('chatId')->Value(0),
                                            HtmlTags::Div('.input-group')->Content(
                                                HtmlTags::Button('.btn.btn-success.closeOrder')->Content(
                                                    'اتمام کار'
                                                )->Attrs(['type' => 'button']),
                                                HtmlTags::Button('.btn.btn-warning.closeChat')->Content(
                                                    'پایان چت'
                                                )->Attrs(['type' => 'button']),
                                                HtmlTags::Button('.btn.btn-outline-danger.p-3.mr-2#recordAudio')->Content(
                                                    HtmlTags::I()->Class(FontAwesome::Microphone()),
                                                )->Attrs(['type' => 'button']),
                                                HtmlTags::Input('.form-control#message_content')->Type('text')->Name('message')->Placeholder('پیام خود را بنویسید...')->AutoComplete(false),
                                                HtmlTags::Span('.input-group-append')->Content(
                                                    HtmlTags::Button('.btn.btn-outline-secondary#attachment')->Type('button')->Content(
                                                        HtmlTags::I()->Class(FontAwesome::Paperclip()),
                                                        ' فاکتور '
                                                    ),
                                                    HtmlTags::Input()->Type('file')->Id('upload-btn')->Attrs(['hidden']),
                                                    HtmlTags::Label('.btn.btn-outline-secondary#attach_file')->For('upload-btn')->Content(
                                                        HtmlTags::I()->Class(FontAwesome::Paperclip()),
                                                        ' فایل '
                                                    )
                                                ),
                                                HtmlTags::Span('.input-group-append')->Content(
                                                    HtmlTags::Button('.btn.btn-primary')->Type('submit')->Content(
                                                        'ارسال'
                                                    )
                                                )
                                            )
                                        )
                                    ),
                                    HtmlTags::Div('.card-footer#card_footer_2')->Attrs(['style' => 'display: none'])->Content(
                                        HtmlTags::Button('.btn.btn-success.w-100.p-2#openChat')->Content(
                                            'باز کردن چت'
                                        ),
                                    )
                                )
                            )
                        )
                ) . $this->buildAttachmentModal();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('اوپراتور') .
                                        $this->Html()->Select('operator_id', 'operator_id', \model\UsersTable::toOption()) .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function buildAttachmentModal(): \FwHtml\Elements\Tags\Div
    {
        return HtmlTags::Div(".modal.fade#attachmentModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-lg')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title')->Content(
                            "ارسال فاکتور"
                        ),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )
                    ),
                    HtmlTags::Form("#factorForm")->Content(
                        HtmlTags::Div('.modal-body')->Content(
                            HtmlTags::Button('.btn.btn-success.p-2.w-100#addRow')->Content(
                                "افزودن ردیف"
                            )->Type('button'),
                            HtmlTags::Table('.table.no-datatable.table-striped.table-bordered')->Content(
                                HtmlTags::Thead()->Content(
                                    HtmlTags::Tr()->Content(
                                        HtmlTags::Th()->Content("#"),
                                        HtmlTags::Th()->Content("مورد پرداخت"),
                                        HtmlTags::Th()->Content("مبلغ"),
                                        HtmlTags::Th()->Content("تخفیف"),
                                        HtmlTags::Th()->Content("عملیات"),
                                    )
                                ),
                                HtmlTags::Tbody("#factorBody")->Content(
                                    function () {
                                        $output = [];
                                        $output[] = HtmlTags::Tr()->Data_('id', 0)->Content(
                                            HtmlTags::Td()->Content(
                                                "1"
                                            ),
                                            HtmlTags::Td()->Content(
                                                HtmlTags::Input('.form-control')
                                                    ->Name("name[0]")->Value("انجام خدمات")->Id('name_0')
                                            ),
                                            HtmlTags::Td()->Content(
                                                $this->Html()->Price('price[0]', 'price_0', 'تومان', ''),
                                            ),
                                            HtmlTags::Td()->Content(
                                                $this->Html()->Percent('discount[0]', 'discount_0', '0'),
                                            ),
                                            HtmlTags::Td()->Content(
                                                HtmlTags::Button('.btn.btn-danger.removeRow')->Type('button')->Content(
                                                    HtmlTags::I('.fa.fa-times')
                                                ),
                                            ),
                                        );
                                        $output[] = HtmlTags::Tr()->Data_('id', 1)->Content(
                                            HtmlTags::Td()->Content(
                                                "2"
                                            ),
                                            HtmlTags::Td()->Content(
                                                HtmlTags::Input('.form-control')
                                                    ->Name("name[1]")->Value("مالیات بر ارزش افزوده")->Id('name_1')
                                            ),
                                            HtmlTags::Td()->Content(
                                                $this->Html()->Price('price[1]', 'price_1', 'تومان', ''),
                                            ),
                                            HtmlTags::Td()->Content(
                                                $this->Html()->Percent('discount[1]', 'discount_1', '0'),
                                            ),
                                            HtmlTags::Td()->Content(
                                                HtmlTags::Button('.btn.btn-danger.removeRow')->Type('button')->Content(
                                                    HtmlTags::I('.fa.fa-times')
                                                ),
                                            ),
                                        );
                                        return implode('', $output);
                                    }
                                ),

                            )
                        ),
                        HtmlTags::Div('.modal-footer.d-flex.flex-wrap.space-between')->Content(
                            HtmlTags::Button('.btn.btn-outline-danger.p-2')->Content(
                                "انصراف"
                            )->Attrs(['type' => 'button'])->Data_('dismiss', 'modal'),
                            HtmlTags::Button('.btn.btn-success.p-2.mr-auto.ml-0')->Content(
                                "تایید"
                            )
                        ),
                    )
                )
            )
        );
    }

    public function archivedChats(Document &$document)
    {

        $document->html = HtmlTags::Section('.content.mt-1')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-3')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline.direct-chat.direct-chat-primary')->Content(
                                    HtmlTags::Div('.card-header')->Content(
                                        HtmlTags::H3('.card-title')->Content(
                                            'مخاطبین'
                                        )
                                    ),
                                    HtmlTags::Div('.card-body')->Content(
                                        HtmlTags::Div('.direct-chat-contacts')->Content(
                                            HtmlTags::Ul('.contacts-list')->Content(
                                                HtmlTags::Input('.form-control.w-100.m-1#chatSearch')->PlaceHolder("جستجو..."),

                                                function () {
                                                    $output = [];
                                                    /** @var UserObject $userObject */
                                                    $userObject = UserObject::instance();
                                                    /** @var ChatsEntity $chat */
                                                    switch ($userObject->getRole()) {
                                                        case "OperatorRole":
                                                            $chats = \model\ChatArchives::getAllFiltered('operator_id', $userObject->getUserId());
                                                            $chats = $chats->sortBy(function (ChatArchivesEntity $chat) {
                                                                return ($chat->lastMessage() instanceof ChatArchivesEntity ? strtotime($chat->lastMessage()->created_at) : 0);
                                                            }, true);
                                                            break;
                                                        case "SupervisorRole":
                                                            $operators = UsersTable::getAllFiltered('supervisor_id', $userObject->getUserId())->map(function (UsersTableEntity $usersTableEntity) {
                                                                return $usersTableEntity->user_id;
                                                            })->all();
                                                            $tmpChats = \model\ChatArchives::Db()->whereIn('operator_id', $operators)->get();
                                                            $chats = [];
                                                            foreach ($tmpChats as $chat) {
                                                                if (!is_array($chats["operator_$chat->operator_id"])) {
                                                                    $chats["operator_$chat->operator_id"] = [];
                                                                }
                                                                $chats["operator_$chat->operator_id"][] = $chat;
                                                            }
                                                            break;
                                                        case "AdminRole":
                                                        default:
                                                            $tmpChats = \model\ChatArchives::getAll();
                                                            $chats = [];
                                                            foreach ($tmpChats as $chat) {
                                                                if (!is_array($chats["operator_$chat->operator_id"])) {
                                                                    $chats["operator_$chat->operator_id"] = [];
                                                                }
                                                                $chats["operator_$chat->operator_id"][] = $chat;
                                                            }

                                                            break;
                                                    }
                                                    $operatorOptions = [];
                                                    foreach ($chats as $operatorId => $ch) {
                                                        if (str($operatorId)->includes('operator_')) {
                                                            /** @var UsersTableEntity $usertable */
                                                            $operatorId = collect(str($operatorId)->explode('_'))->last;
                                                            $usertable = UsersTable::get($operatorId);
                                                            $ch = collect($ch)->sortBy(function (ChatArchivesEntity $chat) {
                                                                return ($chat->lastMessage() instanceof ChatArchivesEntity ? strtotime($chat->lastMessage()->created_at) : 0);
                                                            }, true);
                                                            $output[] = HtmlTags::Li(".chat-operator.mb-4.mt-1#chat_operator_$operatorId")->Data_('id', $operatorId)->Content(
                                                                HtmlTags::Label()->Attrs(['style' => 'color: black;'])->Content(
                                                                    $usertable->user_name ?? "اپراتور شماره {$operatorId}"
                                                                ),
                                                                HtmlTags::Ul('.contacts-list')->Content(
                                                                    function () use ($ch) {
                                                                        $output = [];
                                                                        /** @var ChatArchivesEntity $chat */
                                                                        foreach ($ch as $chat) {
                                                                            $user = $chat->user();
                                                                            if ($user instanceof UsersEntity) {
                                                                                $output[] = HtmlTags::Li()->Content(
                                                                                    HtmlTags::A('.chat-contact')->Data_('id', $chat->chat_id)->Href('#')->Content(
                                                                                        HtmlTags::Img('.contacts-list-img')->Src($user->image()),
                                                                                        HtmlTags::Div('.contacts-list-info')->Content(
                                                                                            HtmlTags::Span('.contacts-list-name')->Content(
                                                                                                HtmlTags::Span('.contact-list-name-inner')->Data_('number', $chat->order_id)->Content(
                                                                                                    $user->firstname . ' ' . $user->lastname . ' - شماره پرونده: ' . $chat->order_id . ' ',
                                                                                                ),

                                                                                                HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                                    en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("Y/m/d", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                                ),
                                                                                                HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                                    en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("H:i", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                                ),
                                                                                            ),
                                                                                            HtmlTags::Div('.w-100.d-flex.flex-wrap.space-between')
                                                                                                ->Attrs(['style' => 'justify-content:   space-between'])->Content(
                                                                                                    HtmlTags::Span('.contacts-list-msg.mt-1')->Content(
                                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? $chat->lastMessage()->htmlPreview() : "")
                                                                                                    ),
                                                                                                    HtmlTags::Span('.contacts-list-count.mt-1')->Content(
                                                                                                        en_to_fa($chat->unreadCount())
                                                                                                    ),
                                                                                                )
                                                                                        )
                                                                                    )
                                                                                );
                                                                            }
                                                                        }
                                                                        return implode('', $output);
                                                                    }
                                                                )
                                                            );
                                                            $operatorOptions[] = $usertable instanceof UsersTableEntity
                                                                ? $usertable->toOption()
                                                                : HtmlTags::Option()->Value($operatorId)->Content(
                                                                    "اپراتور شماره $operatorId"
                                                                );
                                                        } else {
                                                            $chat = $ch;
                                                            if ($chat instanceof ChatsEntity) {
                                                                $user = $chat->user();
                                                                if ($user instanceof UsersEntity) {
                                                                    $output[] = HtmlTags::Li()->Content(
                                                                        HtmlTags::A(".chat-contact")->Data_('id', $chat->chat_id)->Href('#')->Content(
                                                                            HtmlTags::Img('.contacts-list-img')->Src($user->image()),
                                                                            HtmlTags::Div('.contacts-list-info')->Content(
                                                                                HtmlTags::Span('.contacts-list-name')->Content(
                                                                                    HtmlTags::Span('.contact-list-name-inner')->Data_('number', $chat->order_id)->Content(
                                                                                        $user->firstname . ' ' . $user->lastname . ' - شماره پرونده: ' . $chat->order_id . ' ',
                                                                                    ),

                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("Y/m/d", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                    ),
                                                                                    HtmlTags::Small('.contacts-list-date.float-left.ml-1')->Content(
                                                                                        en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? jdate("H:i", strtotime($chat->lastMessage()->created_at)) : "")
                                                                                    ),
                                                                                ),
                                                                                HtmlTags::Div('.w-100.d-flex.flex-wrap.space-between')
                                                                                    ->Attrs(['style' => 'justify-content:   space-between'])->Content(
                                                                                        HtmlTags::Span('.contacts-list-msg.mt-1')->Content(
                                                                                            en_to_fa($chat->lastMessage() instanceof ChatMessagesEntity ? $chat->lastMessage()->htmlPreview() : "")
                                                                                        ),
                                                                                        HtmlTags::Span('.contacts-list-count.mt-1')->Content(
                                                                                            en_to_fa($chat->unreadCount())
                                                                                        ),
                                                                                    )
                                                                            )
                                                                        )
                                                                    );
                                                                }
                                                            }
                                                        }
                                                    }
                                                    array_unshift($output, HtmlTags::Select('.form-control.w-100.m-1')->Id('chatOperatorId')->Content(
                                                        HtmlTags::Option()->Value('all')->Content("همه"),
                                                        implode('', $operatorOptions)
                                                    ));
                                                    return implode('', $output);
                                                }
                                            )
                                        )
                                    )
                                )
                            ),
                            HtmlTags::Div('.col-md-9')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline.direct-chat.direct-chat-primary')->Content(
                                    HtmlTags::Div('.card-header')->Content(
                                        HtmlTags::H3('.card-title#cardTitle')->Content(
                                            'چت'
                                        ),
                                        HtmlTags::P('.card-text.mt-1#cardTitle')->Content(
                                            'برای ارسال فایل، فایل مورد نظر خود را در محدوده مشخص شده رها کنید'
                                        ),
                                        HtmlTags::Div('.card-tools')->Content(

                                            HtmlTags::Button('.btn.btn-success.p-2#unArchiveChat')->Content(
                                                HtmlTags::I()->Class(FontAwesome::Envelope_open()),
                                                HtmlTags::Span('.mr-2')->Content(
                                                    "باز کردن چت"
                                                )
                                            )
                                        )
                                    ),
                                    HtmlTags::Div('.card-body')->Content(
                                        HtmlTags::Div('.direct-chat-messages#chat_content')->Content(),
                                    ),
                                    HtmlTags::Input()->Type('hidden')->Name('chatId')->Id('chatId')->Value(0),

                                )
                            )
                        )
                ) . $this->buildAttachmentModal();
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        