<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Individuals extends View
{

    public $SingularName = 'اطلاعات تکمیلی کاربر';
    public $PluralName = 'اطلاعات تکمیلی کاربران';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('سن'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function ($item) {
                                                                        $a = \model\Users::get($item);
                                                                        return $a->firstname . ' ' . $a->lastname . '(' . $a->mobile . ')';
                                                                    },
                                                                    'individual_plate_number'=>function($item){
                                                                    return implode(' ',json_decode($item,true));
                                                                    }
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {

        $plateChars = /*HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید').*/
            HtmlTags::Option()->Value('الف')->Content('الف').
            HtmlTags::Option()->Value('ب')->Content('ب').
            HtmlTags::Option()->Value('پ')->Content('پ').
            HtmlTags::Option()->Value('ت')->Content('ت').
            HtmlTags::Option()->Value('ث')->Content('ث').
            HtmlTags::Option()->Value('ج')->Content('ج').
            HtmlTags::Option()->Value('چ')->Content('چ').
            HtmlTags::Option()->Value('ح')->Content('ح').
            HtmlTags::Option()->Value('خ')->Content('خ').
            HtmlTags::Option()->Value('د')->Content('د').
            HtmlTags::Option()->Value('ذ')->Content('ذ').
            HtmlTags::Option()->Value('ر')->Content('ر').
            HtmlTags::Option()->Value('ز')->Content('ز').
            HtmlTags::Option()->Value('ژ')->Content('ژ').
            HtmlTags::Option()->Value('س')->Content('س').
            HtmlTags::Option()->Value('ش')->Content('ش').
            HtmlTags::Option()->Value('ص')->Content('ص').
            HtmlTags::Option()->Value('ض')->Content('ض').
            HtmlTags::Option()->Value('ط')->Content('ط').
            HtmlTags::Option()->Value('ظ')->Content('ظ').
            HtmlTags::Option()->Value('ع')->Content('ع').
            HtmlTags::Option()->Value('غ')->Content('غ').
            HtmlTags::Option()->Value('ف')->Content('ف').
            HtmlTags::Option()->Value('ق')->Content('ق').
            HtmlTags::Option()->Value('ک')->Content('ک').
            HtmlTags::Option()->Value('گ')->Content('گ').
            HtmlTags::Option()->Value('ل')->Content('ل').
            HtmlTags::Option()->Value('م')->Content('م').
            HtmlTags::Option()->Value('ن')->Content('ن').
            HtmlTags::Option()->Value('و')->Content('و').
            HtmlTags::Option()->Value('ه')->Content('ه').
            HtmlTags::Option()->Value('ی')->Content('ی');

        $licence_type =  HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید').
            HtmlTags::Option()->Value('1')->Content('پایه یکم').
            HtmlTags::Option()->Value('2')->Content('پایه دوم').
            HtmlTags::Option()->Value('3')->Content('پایه سوم');

        $plate = json_decode($this->getData()['individual_plate_number'],true);

        $childrenBirthdaysTimeStamp = json_decode($this->getData()['individual_children_birthdates']);
        $childrenBirthdays=["1396/06/01" , "1395/02/01" ,"1400/10/01"];
//        foreach ($childrenBirthdaysTimeStamp as $item) {
//            $childrenBirthdays[]=jdate('Y.m.d', $item);
//        }
        var_dump(json_encode($childrenBirthdays,JSON_UNESCAPED_UNICODE));



        $this->isDebug();
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('انتخاب کاربر') .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('تکمیل اطلاعات کاربر') .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کد ملی') .
                                        $this->Html()->NationalCode('individual_national_code') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تلفن ثابت') .
                                        $this->Html()->Tel('individual_telephone') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تاریخ تولد') .
                                        $this->Html()->Date('individual_birthdate') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('شماره کارت') .
                                        $this->Html()->Number('individual_credit_card_number') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('شماره شبا') .
                                        $this->Html()->Number('individual_sheba_number') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات خودروی کاربر') .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('دارای خودرو') .
                                        $this->Html()->Input('individual_has_car_yes_no') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'plateInfo') .
                                        $this->Html()->Label('شماره پلاک') .
                                        $this->Html()->Number('individual_plate_one','individual_plate_one',fa_to_en($plate[0])?:'') .
                                        $this->Html()->Select('individual_plate_char','individual_plate_char',$plateChars) .
                                        hiddenInput($plate[1],'','hiddenPlateChar').
                                        $this->Html()->Number('individual_plate_two','individual_plate_two',fa_to_en($plate[2])?:'') .
//                                        $this->Html()->Price('individual_plate_city_code','individual_plate_city_code','ایران') .
                                        HtmlTags::Div('.input-group.mb-3')->Content(
                                            HtmlTags::Div('.input-group-prepend')->Content(
                                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                                    'ایران'
                                                )
                                            ),
                                            HtmlTags::Input('.form-control#individual_plate_city_code')->Name('individual_plate_city_code')->Value(intval(fa_to_en(str_replace('ایران','',$plate[3])))?:"")->Type('number')
                                        ).
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'licenseInfo') .
                                        $this->Html()->Label('نوع گواهینامه') .
                                        $this->Html()->Select('individual_license_type','individual_license_type',$licence_type) .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات فرزندان کاربر') .


                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('دارای فرزند') .
                                        $this->Html()->Input('individual_has_child_yes_no') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'childrenCount') .
                                        $this->Html()->Label('تعداد فرزندان') .
                                        $this->Html()->Number('individual_children_count') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'childrenBirthdays') .
                                        HtmlTags::Div(".individual_children_birthdates").
                                        hiddenInput(json_encode($childrenBirthdays,JSON_UNESCAPED_UNICODE),'','hiddenBirthdays').
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        