$(function () {
    $(".confirm").on('click', function () {
        let id = $(this).data('id')
        let status = $(this).data('status')
        $.ajax({
            url: "controllers/Orders/Orders",
            type: "POST",
            data: {
                id,
                status,
                controller_type: "changeOrderStatus"
            },
            success: res => {
                if (res === "paymentConfirm") {
                    Swal.fire({
                        icon: "success",
                        title: "تایید پرداخت",
                        text: "پرداخت کاربر با موفقیت تایید شد",
                        confirmButtonText: "فهمیدم",
                        preConfirm: () => {
                            $("#fw_refresh_btn").click()
                        }
                    })
                } else if (res === "serviceConfirm") {
                    Swal.fire({
                        icon: "success",
                        title: "تایید انجام خدمت",
                        text: "سفارش کاربر با موفقیت به اتمام رسید",
                        confirmButtonText: "فهمیدم",
                        preConfirm: () => {
                            $("#fw_refresh_btn").click()
                        }
                    })
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "خطا",
                        text: "عملیات با خطا مواجه شد",
                        confirmButtonText: "فهمیدم"
                    })
                }
            }
        })
    })

    $(".declineOrder").on('click', function () {
        let orderId = $(this).data('id')
		let userId = $(this).data('user')
        $.ajax({
            url: "controllers/Orders/Orders",
            type: "POST",
            data: {
                orderId,
                userId,
                controller_type: "declineOrder"
            },
            success:res=>{
                if (res==='1'){
                    Swal.fire({
                        icon: "success",
                        title: "عدم تایید سفارش",
                        text: "سفارش کاربر با موفقیت رد شد",
                        confirmButtonText: "فهمیدم",
                        preConfirm: () => {
                            $("#fw_refresh_btn").click()
                        }
                    })
                }else if(res==='2') {
                    Swal.fire({
                        icon: "warning",
                        title: "هشدار",
                        text: "عدم تایید سفارش انجام شد اما به کاربر اطلاع داده نشد، لطفا به صورت دستی اقدام به اطلاع رسانی فرمایید",
                        confirmButtonText: "فهمیدم"
                    })
                }else {
                    Swal.fire({
                        icon: "error",
                        title: "خطا",
                        text: "عدم تایید سفارش با خطا مواجه شد",
                        confirmButtonText: "فهمیدم"
                    })
                }
            }
        })
    })

});
