<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\UsersTable;
use View;

class Orders extends View {

    public $SingularName = 'سفارش';
    public $PluralName = 'سفارشات';

    public function main(Document &$document) {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('شماره پرونده'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('تاریخ'),
                                                                    HtmlTags::Th('دسته بندی'),
                                                                    HtmlTags::Th('خدمت'),
                                                                    HtmlTags::Th('انجام دهنده'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'order_id'      => function ($id) {
                                                                        return HtmlTags::Label()->Content("#$id");
                                                                    },
                                                                    'user_id'       => function ($item) {
                                                                        $a = \model\Users::get($item);
                                                                        return $a->user_firstname . ' ' . $a->user_lastname . ' (' . $a->mobile . ")";
                                                                    },
                                                                    'order_date',
                                                                    'category_id'   => function ($item) {
                                                                        return \model\Categories::get($item)->category_name;
                                                                    },
                                                                    'service_id'    => function ($item) {
                                                                        return \model\Services::get($item)->service_name;
                                                                    },
                                                                    'user_table_id' => function ($item) {
                                                                        return \model\UsersTable::get($item)->user_name;
                                                                    },
                                                                    "order_status"  => function ($item) {
                                                                        switch ($item) {
                                                                            case 0:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-warning.p-2')->Content(
                                                                                    "در انتظار تایید"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-warning'></span></h4>";
                                                                                break;
                                                                            case 1:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                                    "انجام شده"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-success'>انجام شده</span></h4>";
                                                                                break;
                                                                            case 2:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-primary.p-2')->Content(
                                                                                    "در انتظار پرداخت"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-primary'>در انتظار پرداخت</span></h4>";
                                                                                break;
                                                                            case 3:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-info.p-2')->Content(
                                                                                    "در حال انجام"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-info'>در حال انجام</span></h4>";
                                                                                break;
                                                                            case 4:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-secondary.p-2')->Content(
                                                                                    "منقضی شده"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-secondary'>منقضی شده</span></h4>";
                                                                                break;
                                                                            case 5:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                                    "عدم تایید"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-danger'>عدم تایید</span></h4>";
                                                                                break;
                                                                            default:
                                                                                return HtmlTags::Span('.badge.badge-pill.badge-dark.p-2')->Content(
                                                                                    "نامشخص"
                                                                                );
//                                                                                return "<h4><span class='badge badge-pill badge-dark'>نامشخص</span></h4>";

                                                                                break;
                                                                        }
                                                                    }
                                                                ], true, true, false, false, function ($value) {
                                                                    if ($value->order_status == 2 && $value->user_table_id > 0) {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.m-1.confirm')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Money())
                                                                        )->Data_('id', $value->order_id)->Data_('status', 'paymentConfirm')->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('تایید پرداخت');
                                                                    } else {
                                                                        return "";
                                                                    }

                                                                }, function ($value) {
                                                                    if ($value->order_status == 3) {
                                                                        return HtmlTags::Button('.btn.btn-outline-info.m-2.p-2.m-1.confirm')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('id', $value->order_id)->Data_('status', 'serviceConfirm')->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('اتمام کار');
                                                                    } else {
                                                                        return "";
                                                                    }
                                                                }, function ($value) {
                                                                    $role = UserObject::instance()->getRole();
                                                                    if ($role == "AdminRole" || $role == "SupervisorRole") {
                                                                        if ($value->order_status == 3 || $value->order_status == 2 || $value->order_status == 0) {
                                                                            return HtmlTags::Button('.btn.btn-outline-primary.m-2.p-2.m-1.allocation')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::User_secret())
                                                                            )->Data_('id', $value->order_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('انتقال سفارش به اپراتور دیگر');
                                                                        } else {
                                                                            return "";
                                                                        }
                                                                    } else {
                                                                        return "";
                                                                    }
                                                                }, function ($value) {
                                                                    if ($value->order_status == 0) {
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.m-1.declineOrder')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('id', $value->order_id)->Data_('user', $value->user_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('رد کردن سفارش');
                                                                    } else {
                                                                        return "";
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                ) . $this->buildOperatorModal();
    }

    private function buildOperatorModal(): \FwHtml\Elements\Tags\Div {
        return HtmlTags::Div(".modal.fade#operatorModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-lg')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title')->Content(
                            "انتخاب اوپراتور"
                        ),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )
                    ),
                    HtmlTags::Div('.modal-body')->Content(
                        HtmlTags::Table('.table.no-datatable.table-striped.table-bordered')->Content(
                            HtmlTags::Thead()->Content(
                                HtmlTags::Tr()->Content(
                                    HtmlTags::Th()->Content("#"),
                                    HtmlTags::Th()->Content("نام اوپراتور"),
                                    HtmlTags::Th()->Content("تعداد سفارشات"),
                                )
                            ),
                            HtmlTags::Tbody()->Content(
                                function () {
                                    $output = [];
                                    /** @var \model\Entity\UsersTableEntity $operator */
                                    foreach (UsersTable::getAllFiltered('role_name', "OperatorRole") as $operator) {
                                        $output[] = HtmlTags::Tr()->Content(
                                            HtmlTags::Td()->Content(
                                                HtmlTags::Input('.form-control.operatorId')->Type('radio')->Name('operator_id')->Value($operator->user_id)
                                            ),
                                            HtmlTags::Td()->Content(
                                                $operator->user_name
                                            ),
                                            HtmlTags::Td()->Content(
                                                \model\Orders::Db()->where('user_table_id', $operator->user_id)->rowCount() . ''
                                            ),
                                        );
                                    }
                                    return implode('', $output);
                                }
                            ),

                        )
                    ),
                    HtmlTags::Div('.modal-footer.d-flex.flex-wrap.space-between')->Content(
                        HtmlTags::Button('.btn.btn-outline-danger.p-2')->Content(
                            "انصراف"
                        )->Attrs(['type' => 'button'])->Data_('dismiss', 'modal'),
                        HtmlTags::Button('.btn.btn-success.p-2.mr-auto.ml-0.confirmChange')->Content(
                            "تایید"
                        )
                    ),
                )
            )
        );
    }

    public function addIndex(Document &$document) {
        $document->html = $this->Form();
    }

    public function Form() {

        $orderStatus = HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') .
            HtmlTags::Option()->Value('2')->Content('تایید سفارش') .
            HtmlTags::Option()->Value('5')->Content('عدم تایید سفارش');

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('کاربر ') .


                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات خدمت ') .


                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('انتخاب دسته بندی') .
                                        $this->Html()->Select('category_id', 'category_id', \model\Categories::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('انتخاب خدمت') .
                                        $this->Html()->Select('service_id', 'service_id', \model\Services::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('هزینه خدمت') .
                                        $this->Html()->Price('order_price', 'order_price', 'تومان', '', true, false, 'form-control', true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('وضعیت سفارش') .
                                        $this->Html()->Select('order_status', 'order_status', $orderStatus) .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات فرم ها ') .


                                        $this->Html()->FormGroupStart(12) .
                                        HtmlTags::Div("#service_form.w-100.d-flex.flex-wrap") .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document) {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        