<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class PaymentTable extends View
{

    public $SingularName = 'تراکنش';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('مبلغ'),
                                                                    HtmlTags::Th('تاریخ'),
                                                                    HtmlTags::Th('پرداخت کننده'),
                                                                    HtmlTags::Th('وضعیت پرداخت'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function ($item) {
                                                                        $a = \model\Users::get($item);
                                                                        return $a->user_firstname . ' ' . $a->user_lastname . ' (' . $a->mobile . ')';
                                                                    },
                                                                    'payment_amount'=>function($item){
                                                                    return en_to_fa($item).' ریال';
                                                                    },
                                                                    'payment_date',
                                                                    'user_table_id'=>function($item){
                                                                        if ($item==0){
                                                                            return "<h4><span class='badge badge-pill badge-warning'>کاربر</span></h4>";
                                                                        }else{
                                                                            $a = \model\UsersTable::get($item)->user_name;
                                                                            return "<h4><span class='badge badge-pill badge-warning'>$a</span></h4>";
                                                                        }
                                                                    },
                                                                    'payment_status' => function ($item) {
                                                                        if ($item == 1) {
                                                                            return "<h4><span class='badge badge-pill badge-success'>پرداخت موفق</span></h4>";
                                                                        } else {
                                                                            return "<h4><span class='badge badge-pill badge-danger'>پرداخت ناموفق</span></h4>";

                                                                        }
                                                                    }
                                                                ],false,false)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        