<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;
class PreparedMessages extends View
{

    public $SingularName = 'پیام آماده';
    public $PluralName = 'پیام های آماده';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('متن پیام'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'prepared_message',
                                                                    'payment_message' => function ($item) {
                                                                        if ($item == 1) {
//                                                                            return "<h4><span class='badge badge-pill badge-success'>پیام تایید پرداخت</span></h4>";
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                                "پیام تایید پرداخت"
                                                                            );
                                                                        } else {
//                                                                            return "<h4><span class='badge badge-pill badge-warning'>پیام آماده </span></h4>";
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-warning.p-2')->Content(
                                                                                "پیام آماده"
                                                                            );
                                                                        }
                                                                    }
                                                                ],true,true,false,false,function ($item){
                                                                    if ($item->payment_message == '1'){
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.deActiveMessage')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('غیرفعالسازی به عنوان پیام تایید پرداخت'),
                                                                        )->Data_('id', $item->prepared_message_id);
                                                                    }else{
                                                                        return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.activeMessage')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('فعالسازی به عنوان پیام تایید پرداخت'),
                                                                        )->Data_('id', $item->prepared_message_id);
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(4) .
                            $this->Html()->Label('متن پیام') .
                            $this->Html()->Input('prepared_message') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        