<?php

namespace view;

use FwAuthSystem\Main\UserObject;
use FwBase\Reports\ReportView;
use FwHtml\Elements\Tags\Main\HtmlTags;


class OperatorReports extends ReportView {
    public $SingularName = 'اپراتور';
    public $PluralName = 'اپراتور ها';

    public function ReportFields(): array {
        $role = UserObject::instance()->getRole();
        if ($role=="AdminRole"){
            $operators = \model\UsersTable::getAllFiltered('role_name',"OperatorRole");
            $output=[];
            foreach ($operators as $item){
                $output[]=HtmlTags::Option()->Value($item->user_id)->Content($item->user_name." (".$item->user_username.")");
            }
            $selectBoxOperators = implode('.',$output);
        }elseif ($role=="SupervisorRole"){
            $supervisorId = UserObject::instance()->getUserId();
            $operators = \model\UsersTable::getAllFiltered('supervisor_id',$supervisorId);
            $output=[];
            foreach ($operators as $item){
                $output[]=HtmlTags::Option()->Value($item->user_id)->Content($item->user_name." (".$item->user_username.")");
            }
            $selectBoxOperators = implode('.',$output);
        }else{
            $operatorId = UserObject::instance()->getUserId();
            $operator = \model\UsersTable::get($operatorId);
            $selectBoxOperators = HtmlTags::Option()->Selected()->Value($operatorId)->Content($operator->user_name." (".$operator->user_username.")");
        }
        return [
            $this->DateFromTo("date", 'تاریخ'),
            $this->SimpleSelect("user_table_id", 'انتخاب اپراتور', $selectBoxOperators, 6,false),
            $this->SimpleSelect("status", 'وضعیت', HtmlTags::Option()->Value(0)->Content("در انتظار تایید") . HtmlTags::Option()->Value(1)->Content("انجام شده") . HtmlTags::Option()->Value(2)->Content("در انتظار پرداخت") . HtmlTags::Option()->Value(3)->Content("در حال انجام") . HtmlTags::Option()->Value(4)->Content("منقضی شده"). HtmlTags::Option()->Value(5)->Content("عدم تایید"), 6),

        ];
    }

    public function thList(): \FwHtml\Elements\Tags\Tr {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th()->Content("#"),
            HtmlTags::Th()->Content("کد سفارش"),
            HtmlTags::Th()->Content("اپراتور"),
            HtmlTags::Th()->Content("کاربر"),
            HtmlTags::Th()->Content("دسته بندی"),
            HtmlTags::Th()->Content("خدمت"),
            HtmlTags::Th()->Content("هزینه"),
            HtmlTags::Th()->Content("تاریخ"),
            HtmlTags::Th()->Content("وضعیت"),
        );
    }

    public function toRow($order, $i): \FwHtml\Elements\Tags\Tr {
        /** @var \model\Entity\UsersTableEntity $user */
        $userTable = \model\UsersTable::get($order->user_table_id);
        $user = \model\Users::get($order->user_id);
        $cat = \model\Categories::get($order->category_id)->category_name;
        $service = \model\Services::get($order->service_id)->service_name;

        switch ($order->order_status) {
            case 0:
                $status = HtmlTags::Span('.badge.badge-pill.badge-warning.p-2')->Content(
                    "در انتظار تایید"
                );
                break;
            case 1:
                $status = HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                    "انجام شده"
                );
                break;
            case 2:
                $status = HtmlTags::Span('.badge.badge-pill.badge-primary.p-2')->Content(
                    "در انتظار پرداخت"
                );
                break;
            case 3:
                $status = HtmlTags::Span('.badge.badge-pill.badge-info.p-2')->Content(
                    "در حال انجام"
                );
                break;
            case 4:
                $status = HtmlTags::Span('.badge.badge-pill.badge-secondary.p-2')->Content(
                    "منقضی شده"
                );
                break;
            case 5:
                $status = HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                    "عدم تایید"
                );
                break;
            default:
                $status = HtmlTags::Span('.badge.badge-pill.badge-dark.p-2')->Content(
                    "نامشخص"
                );
                break;
        }

        return HtmlTags::Tr()->Content(
            HtmlTags::Td()->Content("$i"),
            HtmlTags::Td()->Content("#".$order->order_id),
            HtmlTags::Td()->Content($userTable->user_name . ' - (' . $userTable->user_username . ')'),
            HtmlTags::Td()->Content($user->user_firstname.' '.$user->user_lastname." (".$user->mobile.")"),
            HtmlTags::Td()->Content($cat),
            HtmlTags::Td()->Content($service),
            HtmlTags::Td()->Content(price_format($order->order_price)),
            HtmlTags::Td()->Content(jdate('Y/m/d', $order->order_date)."   ".jdate('H:i', $order->order_date)),
            HtmlTags::Td()->Content($status),
        );
    }


}
