<?php

namespace view;

use FwBase\Reports\ReportView;
use FwHtml\Elements\Tags\Main\HtmlTags;
use helpers\PaymentStatus;
use model\PaymentTable;

class SaleReports extends ReportView {
    public $SingularName = 'تراکنش';
    public $PluralName = 'تراکنش ها';

    public function ReportFields(): array {
        return [
            $this->DateFromTo("date", 'تاریخ'),
            $this->SimpleSelect("user_id", 'انتخاب کاربر', \model\Users::toOption(), 4),
            $this->SimpleSelect("gate", 'درگاه پرداخت', HtmlTags::Option()->Content("زرین پال"), 4),
            $this->SimpleSelect("status", 'وضعیت', HtmlTags::Option()->Value(1)->Content("پرداخت موفق") . HtmlTags::Option()->Value(2)->Content("پرداخت نا موفق"), 4),
        ];
    }

    public function thList(): \FwHtml\Elements\Tags\Tr {
        return HtmlTags::Tr()->Content(
            HtmlTags::Th()->Content("#"),
            HtmlTags::Th()->Content("کاربر"),
            HtmlTags::Th()->Content("نوع تراکنش"),
            HtmlTags::Th()->Content("کد رهگیری"),
            HtmlTags::Th()->Content("تاریخ"),
            HtmlTags::Th()->Content("ساعت"),
            HtmlTags::Th()->Content("وضعیت"),
        );
    }

    public function toRow($order, $i): \FwHtml\Elements\Tags\Tr {
        /** @var \model\Entity\UsersEntity $user */
        $user = \model\Users::get($order->user_id);
        return HtmlTags::Tr()->Content(
            HtmlTags::Td()->Content("$i"),
            HtmlTags::Td()->Content($user->firstname . ' ' . $user->lastname . ' - (' . $user->mobile . ')'),
            HtmlTags::Td()->Content(PaymentTable::getType($order->payment_type)),
            HtmlTags::Td()->Content($order->payment_resnum),
            HtmlTags::Td()->Content(jdate('Y/m/d', $order->payment_date)),
            HtmlTags::Td()->Content(jdate('H:i', $order->payment_date)),
            HtmlTags::Td()->Content(
                $order->payment_status == 1
                    ? HtmlTags::Span('.badge.badge-success.p-2')->Content(
                    "پرداخت شده"
                )
                    : HtmlTags::Span('.badge.badge-danger.p-2')->Content(
                    "پرداخت نا موفق"
                )
            ),
        );
    }


}
