<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\Entity\ServicesEntity;
use View;

class Services extends View
{
    use \SortRowsView;


    public $SingularName = 'خدمت';
    public $PluralName = 'خدمات';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd(),
                                                $this->sortButton(),

                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('آیکون'),
                                                                    HtmlTags::Th('خدمات'),
                                                                    HtmlTags::Th('دسته بندی'),
                                                                    HtmlTags::Th('خدمت پرکاربرد'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
//                                                                    'showImage'=>'service_icon',
'service_name',
'category_id'    => function ($item) {
    return \model\Categories::get($item)->name;
},
'service_useful' => function ($item) {
    if ($item == 1) {
//        return "<h4><span class='badge badge-pill badge-success'> بله </span></h4>";
        return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
            "بله"
        );
    } else {
//        return "<h4><span class='badge badge-pill badge-danger'>خیر</span></h4>";
        return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
            "خیر"
        );
    }
}
                                                                ], true, true, false, false, function (ServicesEntity $service) {
                                                                    return $this->Html()->actionBtn(\controller\Services::RelPath(['service_id' => $service->service_id], 'formGenerator'), 'فرم', FontAwesome::Creative_commons(), 'btn-outline-primary');
                                                                }, function ($item) {
                                                                    if ($item->service_useful == '1') {
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.p-2.notUseful')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('id', $item->service_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('غیر فعالسازی سرویس پرکاربرد');
                                                                    } else {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.p-2.useful')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('id', $item->service_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('فعالسازی سرویس پرکاربرد');
                                                                    }
                                                                }, function ($item) {
                                                                    if ($item->service_active == '1') {
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.p-2.serviceDeActive')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('id', $item->service_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('غیر فعالسازی سرویس ');
                                                                    } else {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.p-2.serviceActive')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('id', $item->service_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('فعالسازی سرویس ');
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('service_icon', 'image/png') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('service_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب دسته بندی') .
                                        $this->Html()->Select('category_id', 'category_id', \model\Categories::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('ارسال پیش فاکتوربعد از ثبت درخواست') .
                                        $this->Html()->Input('send_prefactor_yes_no', 'send_prefactor_yes_no') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('ویدیوی آموزشی') .
                                        $this->Html()->Video('service_video'),
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('قیمت خدمت') .
                                        $this->Html()->Price('service_price', 'service_price') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('پیام آماده در آغاز چت') .
                                        $this->Html()->TextArea('service_startup_message', 'service_startup_message') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('تصویر آغاز چت') .
                                        $this->Html()->ImageInput('service_startup_image') .
                                        $this->Html()->FormGroupEnd() .
                                        hiddenInput('0', 'view_order'),

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function formGenerator(Document &$document)
    {
        $this->submit();

        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-secondary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle("فرم ساز"),
                                                HtmlTags::Div('.card-tools')->Content(

                                                    HtmlTags::Button('.btn.btn-tool')->Type('button')->Data_widget('collapse')->Content(
                                                        HtmlTags::I('.fa.fa-minus')
                                                    ),
//                                                    HtmlTags::Button('.btn.btn-tool#add_item')->Type('button')->Content(
//                                                        HtmlTags::I('.fa.fa-plus')
//                                                    ),
                                                    HtmlTags::Div('.btn-group')->Content(
                                                        HtmlTags::Button('.btn.btn-tool.dropdown-toggle')->Attrs([
                                                            'type'          => 'button',
                                                            'data-toggle'   => 'dropdown',
                                                            'aria-expanded' => 'true',
                                                        ])->Content(
                                                            HtmlTags::I('.fa.fa-wrench')
                                                        ),
                                                        HtmlTags::Div('.dropdown-menu.dropdown-menu-left')->Attrs(['style' => 'position: absolute; transform: translate3d(0px, 31px, 0px); top: 0px; left: 0px; will-change: transform;'])->Role('menu')->X_placement('bottom-start')->Content(
                                                            HtmlTags::A('.dropdown-item#addSelect')->Href('#')->Content(
                                                                'ورودی انتخابی(select)'
                                                            ),
                                                            HtmlTags::A('.dropdown-item#addImage')->Href('#')->Content(
                                                                'ورودی تصویر(image)'
                                                            ),
                                                            HtmlTags::A('.dropdown-item#add_item_1')->Href('#')->Content(
                                                                'ورودی متنی'
                                                            )
                                                        )
                                                    )
                                                ),
                                                $this->Html()->refreshAndBack(),

                                            ),
                                        $this->Html()->FormStart('saveForm') .
                                        hiddenInput($this->getData()->service_id, 'service_id'),
                                        HtmlTags::Div('.col-md-12.d-flex.flex-wrap.greatParent#formData')->Content(
                                            function () {
                                                $form = json_decode($this->getData()->service_form);
                                                if ($form and !empty($form) and count((array)$form) > 0) {
                                                    $output = [];
                                                    $i = 0;
                                                    foreach ($form as $item) {
                                                        $output[] = HtmlTags::Div(".form-group.col-md-$item->col_md_.parentDiv")->Content(
                                                            HtmlTags::Div(".card.card-danger.card-outline.bg-transparent#card_$i")->Content(
                                                                HtmlTags::Div('.card-header')->Content(
                                                                    HtmlTags::Div('.card-title')->Content(
                                                                        HtmlTags::H5()->Content(
                                                                            function () use ($item) {
                                                                                switch ($item->type) {
                                                                                    case "select":
                                                                                        return "ورودی انتخابی";
                                                                                    case "image":
                                                                                        return "ورودی تصویر";
                                                                                    case "input":
                                                                                    default:
                                                                                        return "ورودی نوشتاری";
                                                                                }
                                                                            }
                                                                        )
                                                                    ),
                                                                    HtmlTags::Div('.card-tools')->Content(
                                                                        HtmlTags::Button('.btn.btn-tool.removeMe')->Type('button')->Content(
                                                                            HtmlTags::I('.fa.fa-times')
                                                                        )
                                                                    )
                                                                ),
                                                                function () use ($item, $i) {
                                                                    $item->type = $item->type ?? $item->col_type;
                                                                    switch ($item->type) {
                                                                        case "image":
                                                                            return HtmlTags::Div('.card-body')->Content(
                                                                                HtmlTags::Div('.input-group.w-100')->Content(
                                                                                    HtmlTags::Select('.form-control.w-50.select2-hidden-accessible')->Required()->Name("imageData[item_$i][format]")->Tabindex('-1')->Aria_hidden('true')->Content(
                                                                                        HtmlTags::Option()->Value('png')->Content(
                                                                                            'فرمت png'
                                                                                        )->Selected($item->imageData->format == "png"),
                                                                                        HtmlTags::Option()->Value('png')->Content(
                                                                                            'فرمت jpg'
                                                                                        )->Selected($item->imageData->format == "jpg"),
                                                                                    ),
                                                                                ),
                                                                                HtmlTags::Div('.input-group.mt-2')->Content(),
                                                                                HtmlTags::Div('.input-group.w-100')->Content(
                                                                                    HtmlTags::Input()->Type('hidden')->Name("col_type[item_$i]")->Value('image'),
                                                                                    HtmlTags::Input('.form-control.w-50')->Required()->Name("label[item_$i]")->Placeholder('عنوان')
                                                                                        ->Value($item->label),

                                                                                    HtmlTags::Input('.form-control.w-50')
                                                                                        ->Required('')->Name("placeholder[item_$i]")->Placeholder('متن داخل فیلد')
                                                                                        ->Value($item->placeholder ?? ""),
                                                                                    HtmlTags::Input('.form-control.w-100')
                                                                                        ->Required('')->Name("hint[item_$i]")->Placeholder('راهنما')
                                                                                        ->Value($item->hint ?? ""),
                                                                                    HtmlTags::Input('.form-control.w-100')
                                                                                        ->Required('')->Name("errorText[item_$i]")->Placeholder('خطا')
                                                                                        ->Value($item->errorText ?? ""),
                                                                                ),
                                                                                HtmlTags::Div('.card-footer.mt-2')->Content(
                                                                                    HtmlTags::Div('.validations')->Content(
                                                                                        HtmlTags::Div('.form-group')->Content(
                                                                                            HtmlTags::Label()->Content(
                                                                                                'اعتبارسنجی'
                                                                                            ),
                                                                                            HtmlTags::Div('.input-group.w-100')->Content(
                                                                                                HtmlTags::Div('.input-group-prepend')->Content(
                                                                                                    HtmlTags::Div('.input-group-text')->Content(
                                                                                                        'عرض'
                                                                                                    ),
                                                                                                    HtmlTags::Input('.form-control')->Value('150')->Name("imageData[item_$i][width]")->Value($item->imageData->width ?? ''),
                                                                                                    HtmlTags::Div('.input-group-text')->Content(
                                                                                                        'طول'
                                                                                                    ),
                                                                                                    HtmlTags::Input('.form-control')->Value('150')->Name("imageData[item_$i][height]")->Value($item->imageData->height ?? '')
                                                                                                )
                                                                                            )
                                                                                        )
                                                                                    ),
                                                                                    HtmlTags::Input('.slider.w-100')->Required()->Name("slider[item_$i]")->Value($item->col_md_ ?? 4)->Min('1')->Max('12')->Type('range')
                                                                                )
                                                                            );
                                                                            break;
                                                                        case 'select':
                                                                            return HtmlTags::Div('.card-body')->Content(
                                                                                    HtmlTags::Div('.input-group.w-100')->Content(
                                                                                        HtmlTags::Input('.form-control.w-50')
                                                                                            ->Required('')->Name("label[item_$i]")->Placeholder('عنوان')
                                                                                            ->Value($item->label),
                                                                                        HtmlTags::Input('.form-control.w-50')
                                                                                            ->Required('')->Name("placeholder[item_$i]")->Placeholder('متن داخل فیلد')
                                                                                            ->Value($item->placeholder ?? ""),
                                                                                        HtmlTags::Input('.form-control.w-100')
                                                                                            ->Required('')->Name("hint[item_$i]")->Placeholder('راهنما')
                                                                                            ->Value($item->hint ?? ""),
                                                                                        HtmlTags::Input('.form-control.w-100')
                                                                                            ->Required('')->Name("errorText[item_$i]")->Placeholder('خطا')
                                                                                            ->Value($item->errorText ?? ""),
                                                                                    ),
                                                                                    HtmlTags::Div('.input-group.mt-4.w-100')->Content(
                                                                                        HtmlTags::Input()->Type('checkbox')->Name("required[item_$i]")->Value(1)->Attrs(['checked' => $item->required == true]),
                                                                                        HtmlTags::Span('فیلد اجباری')->Class('mr-1'),
                                                                                    ),
                                                                                    HtmlTags::Div('.input-group.mt-2')->Content(
                                                                                        HtmlTags::Input()->Type('hidden')->Name("col_type[item_$i]")->Value('select'),
                                                                                        HtmlTags::Div('.card.card-info.card-outline.col-md-12')->Content(
                                                                                            HtmlTags::Div('.card-header')->Content(
                                                                                                HtmlTags::Div('.card-title')->Content(
                                                                                                    'گزینه ها'
                                                                                                ),
                                                                                                HtmlTags::Div('.card-tools')->Content(
                                                                                                    HtmlTags::Button('.btn.btn-tool.addOption')->Type('button')->Data_value($i)->Content(
                                                                                                        HtmlTags::I('.fa.fa-plus-square-o')
                                                                                                    )
                                                                                                )
                                                                                            ),
                                                                                            HtmlTags::Div('.card-body')->Content(
                                                                                                function () use ($item, $i) {
                                                                                                    $output = [];
                                                                                                    $options = $item->options;
                                                                                                    if ($options) {
                                                                                                        foreach ($options as $option) {
                                                                                                            $output[] = HtmlTags::Div('.form-group.col-md-12.optionGroup')->Content(
                                                                                                                HtmlTags::Div('.input-group')->Content(
                                                                                                                    HtmlTags::Div('.input-group-prepend')->Content(
                                                                                                                        HtmlTags::Button('.btn.btn-danger.removeOption')->Type('button')->Content(
                                                                                                                            HtmlTags::I('.fa.fa-times')
                                                                                                                        )
                                                                                                                    ),
                                                                                                                    HtmlTags::Input('.form-control')->Name("options[item_$i][]")->Value($option)->Placeholder('مثال؛ گزینه ی یک')
                                                                                                                )
                                                                                                            );
                                                                                                        }
                                                                                                        return implode('', $output);
                                                                                                    } else {
                                                                                                        return HtmlTags::Div('.form-group.col-md-12.optionGroup')->Content(
                                                                                                            HtmlTags::Div('.input-group')->Content(
                                                                                                                HtmlTags::Div('.input-group-prepend')->Content(
                                                                                                                    HtmlTags::Button('.btn.btn-danger.removeOption')->Type('button')->Content(
                                                                                                                        HtmlTags::I('.fa.fa-times')
                                                                                                                    )
                                                                                                                ),
                                                                                                                HtmlTags::Input('.form-control')->Name("options[item_0][]")->Placeholder('مثال؛ گزینه ی یک')
                                                                                                            )
                                                                                                        );
                                                                                                    }
                                                                                                },

                                                                                            )
                                                                                        )
                                                                                    )
                                                                                ) . HtmlTags::Div('.card-footer')->Content(
                                                                                    HtmlTags::Div('.validations')->Content(
                                                                                        HtmlTags::Input('.slider.w-100')->Required('')->Name("slider[item_$i]")->Value($item->col_md_ ?? 4)->Min('1')->Max('12')->Type('range'),

                                                                                    )
                                                                                );
                                                                            break;
                                                                        case "input":
                                                                        default:
                                                                            return HtmlTags::Div('.card-body')->Content(
                                                                                    HtmlTags::Div('.input-group')->Content(
                                                                                        HtmlTags::Input()->Type('hidden')->Name("col_type[item_$i]")->Value($item->type ?? "input"),
                                                                                        HtmlTags::Input()->Type('hidden')->Name("class[item_$i]")->Value('*'),
                                                                                        HtmlTags::Input('.form-control.w-50')
                                                                                            ->Required('')->Name("label[item_$i]")->Placeholder('عنوان')
                                                                                            ->Value($item->label),
                                                                                        HtmlTags::Input('.form-control.w-50')
                                                                                            ->Required('')->Name("placeholder[item_$i]")->Placeholder('متن داخل فیلد')
                                                                                            ->Value($item->placeholder ?? ""),
                                                                                        HtmlTags::Input('.form-control.w-100')
                                                                                            ->Required('')->Name("hint[item_$i]")->Placeholder('راهنما')
                                                                                            ->Value($item->hint ?? ""),
                                                                                        HtmlTags::Input('.form-control.w-100')
                                                                                            ->Required('')->Name("errorText[item_$i]")->Placeholder('خطا')
                                                                                            ->Value($item->errorText ?? ""),
                                                                                    ),
                                                                                    HtmlTags::Div('.input-group.mt-4.w-100')->Content(
                                                                                        HtmlTags::Input()->Type('checkbox')->Name("required[item_$i]")->Value(1)->Attrs(['checked' => $item->required == true]),
                                                                                        HtmlTags::Span('فیلد اجباری')->Class('mr-1'),
                                                                                    ),
                                                                                ) . HtmlTags::Div('.card-footer')->Content(
                                                                                    HtmlTags::Div('.validations')->Content(
                                                                                        HtmlTags::Div('.form-group')->Content(
                                                                                            HtmlTags::Label()->Content(
                                                                                                'اعتبارسنجی'
                                                                                            ),
                                                                                            HtmlTags::Select('.form-control.w-100')->Name("validations[item_$i]")->Content(
                                                                                                HtmlTags::Option()->Value('Input')->Content(
                                                                                                    'فاقد اعتبارسنجی'
                                                                                                )->Selected($item->validation == "Input"),
                                                                                                HtmlTags::Option()->Value('Price')->Content(
                                                                                                    'قیمت'
                                                                                                )->Selected($item->validation == "Price"),

                                                                                                HtmlTags::Option()->Value('Percent')->Content(
                                                                                                    'درصد'
                                                                                                )->Selected($item->validation == "Percent"),

                                                                                                HtmlTags::Option()->Value('NationalCode')->Content(
                                                                                                    'کد ملی'
                                                                                                )->Selected($item->validation == "NationalCode"),

                                                                                                HtmlTags::Option()->Value('Url')->Content(
                                                                                                    'آدرس صفحه'
                                                                                                )->Selected($item->validation == "Url"),

                                                                                                HtmlTags::Option()->Value('Mobile')->Content(
                                                                                                    'شماره موبایل'
                                                                                                )->Selected($item->validation == "Mobile"),

                                                                                                HtmlTags::Option()->Value('Tel')->Content(
                                                                                                    'شماره تلفن'
                                                                                                )->Selected($item->validation == "Tel"),

                                                                                                HtmlTags::Option()->Value('Number')->Content(
                                                                                                    'فقط عدد'
                                                                                                )->Selected($item->validation == "Number"),

                                                                                                HtmlTags::Option()->Value('English')->Content(
                                                                                                    'فقط انگلیسی'
                                                                                                )->Selected($item->validation == "English"),

                                                                                                HtmlTags::Option()->Value('Email')->Content(
                                                                                                    'ایمیل'
                                                                                                )->Selected($item->validation == "Email"),
                                                                                                HtmlTags::Option()->Value('Date')->Content(
                                                                                                    'تاریخ'
                                                                                                )->Selected($item->validation == "Date"),
                                                                                                HtmlTags::Option()->Value('Plate')->Content(
                                                                                                    'پلاک'
                                                                                                )->Selected($item->validation == "Plate"),
                                                                                            )
                                                                                        ),
                                                                                        HtmlTags::Input('.slider.w-100')->Required('')->Name("slider[item_$i]")->Value($item->col_md_ ?? 4)->Min('1')->Max('12')->Type('range'),

                                                                                    )
                                                                                );
                                                                            break;
                                                                    }
                                                                },


                                                            ),
                                                        );
                                                        $i++;
                                                    }
                                                    return collect($output)->join('');
                                                } else {
                                                    return HtmlTags::Div('.form-group.col-md-4.parentDiv')->Content(
                                                        HtmlTags::Div('.card.card-danger.card-outline.bg-transparent#card_0')->Content(
                                                            HtmlTags::Div('.card-header')->Content(
                                                                HtmlTags::Div('.card-title')->Content(
                                                                    HtmlTags::H5()->Content(
                                                                        'ورودی نوشتاری (معمولی)'
                                                                    ),
                                                                ),
                                                                HtmlTags::Div('.card-tools')->Content(
                                                                    HtmlTags::Button('.btn.btn-tool.removeMe')->Type('button')->Content(
                                                                        HtmlTags::I('.fa.fa-times')
                                                                    )
                                                                )
                                                            ),
                                                            HtmlTags::Div('.card-body')->Content(
                                                                HtmlTags::Div('.input-group')->Content(
                                                                    HtmlTags::Input()->Type('hidden')->Name('col_type[item_0]')->Value('input'),
                                                                    HtmlTags::Input()->Type('hidden')->Name('class[item_0]')->Value('*'),
                                                                    HtmlTags::Input('.form-control.w-50')->Name('label[item_0]')->Placeholder('عنوان فیلد'),
                                                                    HtmlTags::Input('.form-control.w-50')->Name('placeholder[item_0]')->Placeholder('راهنمای داخل فیلد'),
                                                                    HtmlTags::Input('.form-control.w-100')->Name('hint[item_0]')->Placeholder('متن راهنما'),
                                                                    HtmlTags::Input('.form-control.w-50')->Name("errorText[item_0]")->Placeholder('متن خطا')->Value(""),
                                                                )
                                                            ),
                                                            HtmlTags::Div('.card-footer')->Content(
                                                                HtmlTags::Div('.validations')->Content(
                                                                    HtmlTags::Div('.form-group')->Content(
                                                                        HtmlTags::Label()->Content(
                                                                            'اعتبارسنجی'
                                                                        ),
                                                                        HtmlTags::Select('.form-control.w-100')->Name('validations[item_0]')->Content(
                                                                            HtmlTags::Option()->Value('Input')->Content(
                                                                                'فاقد اعتبارسنجی'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Price')->Content(
                                                                                'قیمت'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Percent')->Content(
                                                                                'درصد'
                                                                            ),
                                                                            HtmlTags::Option()->Value('NationalCode')->Content(
                                                                                'کد ملی'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Url')->Content(
                                                                                'آدرس صفحه'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Mobile')->Content(
                                                                                'شماره موبایل'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Tel')->Content(
                                                                                'شماره تلفن'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Number')->Content(
                                                                                'فقط عدد'
                                                                            ),
                                                                            HtmlTags::Option()->Value('English')->Content(
                                                                                'فقط انگلیسی'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Email')->Content(
                                                                                'ایمیل'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Date')->Content(
                                                                                'تاریخ'
                                                                            ),
                                                                            HtmlTags::Option()->Value('Plate')->Content(
                                                                                'پلاک'
                                                                            ),
                                                                        )
                                                                    )
                                                                ),
                                                                HtmlTags::Input('.slider.w-100')->Required('')->Name('slider[item_0]')->Value('4')->Min('1')->Max('12')->Type('range')
                                                            )
                                                        )
                                                    );
                                                }
                                            }
                                        ),
                                        $this->Html()->CardFooter("ذخیره فرم")
                                    ),
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        