<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class SmsGroups extends View
{

    public $SingularName = 'پیامک گروهی';
    public $PluralName = 'پیامک های گروهی';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('متن پیامک'),
                                                                    HtmlTags::Th('کاربران'),
                                                                    HtmlTags::Th('تاریخ ارسال'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'sms_text',
                                                                    'user_ids' => function ($item) {
                                                                        $decode = json_decode($item, true);
                                                                        $output = [];
                                                                        foreach ($decode as $value) {
                                                                            $user = \model\Users::get($value);
                                                                            $output[] = $user->user_firstname . ' ' . $user->user_lastname . ' (' . $user->mobile . ')';
                                                                        }
                                                                        return implode(' / ', $output);
                                                                    },
                                                                    'sms_group_date'
                                                                ], false, false, false, false)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        $userGroups = HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') .
            HtmlTags::Option()->Value(1)->Content("انتخاب کاربران بر اساس موجودی کیف پول") .
            HtmlTags::Option()->Value(2)->Content("انتخاب کاربران بر اساس موقعیت جغرافیایی") .
            HtmlTags::Option()->Value(3)->Content("انتخاب کاربران بر اساس تعداد تراکنش");


        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

//                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('کاربران') .
//
//                                        $this->Html()->FormGroupStart(12) .
//                                        $this->Html()->Label('کاربران') .
//                                        $this->Html()->Select('user_ids[]', 'user_ids', \model\Users::toOption(), true, false, true) .
//                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('انتخاب کاربران') .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کاربران') .
                                        $this->Html()->Select('user_group', 'user_group', $userGroups) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'subGroup d-none') .
                                        $this->Html()->Label('انتخاب کاربران') .
                                        HtmlTags::Div("#user_sub_group").
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'priceDiv d-none') .
                                        $this->Html()->Label('قیمت') .
                                        $this->Html()->Price('price', 'price','تومان','',false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'countDiv d-none') .
                                        $this->Html()->Label('تعداد تراکنش') .
                                        $this->Html()->Input('count', 'count','',false) .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('متن پیامک') .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('متن پیامک') .
                                        $this->Html()->TextArea('sms_text','sms_text') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        