<?

namespace view;

use DOMWrap\Document;
use model\Entity\MoviesEntity;
use model\Entity\SerialsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class TopSliders extends View {
    use \SortRowsView;
	
	public $SingularName = 'اسلایدر اصلی';
	public $PluralName = 'اسلایدر های اصلی';
	
	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd(),
                                                $this->sortButton(),
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('اسلایدر'),
																	HtmlTags::Th('لینک متصل'),
																	HtmlTags::Th('تعداد بازدید از بنر'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
                                                                    'showImage'=>'top_slider_image',
                                                                    'top_slider_link',
                                                                    'top_slider_view' => function($item){
                                                                    return en_to_fa($item).' بازدید';
                                                                    }
																])
															)
													)
											)
									)
							)
						)
				);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	
	public function Form() : string {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('بنر') .
										$this->Html()->ImageInput('top_slider_image') .
										$this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Input('top_slider_link','top_slider_link','',false) .
                                        $this->Html()->FormGroupEnd() .

										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
