<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class UserTemps extends View
{

    public $SingularName = 'کاربر موقت';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کاربر'),HtmlTags::Th('ایمیل'),HtmlTags::Th('رمز عبور'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['temp_full_name','temp_email','temp_password'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('نام کاربر') .
                            $this->Html()->Input('temp_full_name') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('ایمیل') .
                            $this->Html()->Input('temp_email') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('رمز عبور') .
                            $this->Html()->Input('temp_password') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('کشور') .
                            $this->Html()->Input('temp_country') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('کد تایید') .
                            $this->Html()->Input('temp_code') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('تاریخ') .
                            $this->Html()->Input('temp_date') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        