
$(function () {
    $(".sendNotif").on('click', function () {
        let id = $(this).data('id');
        Swal.fire({
            title: "ارسال نوتیفیکیشن",
            text: "لطفا متن خود را وارد کنید",
            input: 'text',
            showCancelButton: true,
            confirmButtonText: 'ارسال',
            cancelButtonText:'انصراف',
            confirmButtonColor:"green",
            cancelButtonColor:"red",
            reverseButtons: true,
            preConfirm: (text) => {
                $.ajax({
                    url: "controllers/Users/Users",
                    type: "POST",
                    data:{
                        id,
                        text,
                        controller_type: "sensNotif"
                    },
                    success:res=>{
                        if (res === "1"){
                            Swal.fire({
                                icon:"success",
                                title:"ارسال نوتیفیکیشن",
                                text : 'ارسال نوتیفیکیشن با موفقیت انجام شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }else {
                            Swal.fire({
                                icon:"error",
                                title:"ارسال نوتیفیکیشن",
                                text : 'ارسال نوتیفیکیشن با خطا مواجه شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }
                })
            }
        })
    })

    $(".sendSMS").on('click',function (){
        let mobile = $(this).data('mobile');
        Swal.fire({
            title: "ارسال اس ام اس",
            text: "لطفا متن خود را وارد کنید",
            input: 'text',
            showCancelButton: true,
            confirmButtonText: 'ارسال',
            cancelButtonText:'انصراف',
            confirmButtonColor:"green",
            cancelButtonColor:"red",
            reverseButtons: true,
            preConfirm: (text) => {
                $.ajax({
                    url: "controllers/Users/Users",
                    type: "POST",
                    data:{
                        mobile,
                        text,
                        controller_type: "sensSMS"
                    },
                    success:res=>{
                        if (res === "1"){
                            Swal.fire({
                                icon:"success",
                                title:"ارسال اس ام اس",
                                text : 'ارسال پیامک با موفقیت انجام شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }else {
                            Swal.fire({
                                icon:"error",
                                title:"ارسال اس ام اس",
                                text : 'ارسال پیامک با خطا مواجه شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }
                })
            }
        })
    })

    $(".walletCharge").on('click',function (){
        let id = $(this).data('id')
        Swal.fire({
            title: "شارژ کیف پول",
            text: "لطفا مبلغ شارژ کیف پول کاربر را وارد کنید",
            input: 'text',
            showCancelButton: true,
            confirmButtonText: 'تایید',
            cancelButtonText:'انصراف',
            confirmButtonColor:"green",
            cancelButtonColor:"red",
            reverseButtons: true,
            preConfirm: (text) => {
                $.ajax({
                    url: "controllers/Users/Users",
                    type: "POST",
                    data:{
                        id,
                        text,
                        controller_type: "chargeWallet"
                    },
                    success:res=>{
                        if (res === "1"){
                            Swal.fire({
                                icon:"success",
                                title:"شارژ کیف پول",
                                text : 'شارژ کیف پول کاربر با موفقیت انجام شد',
                                confirmButtonText:"فهمیدم",
                                preConfirm:()=>{
                                    $("#fw_refresh_btn").click()
                                }
                            })
                        }else {
                            Swal.fire({
                                icon:"error",
                                title:"شارژ کیف پول",
                                text : 'شارژ کیف پول کاربر با خطا مواجه شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }
                })
            }
        })
    })
})