<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Users extends View
{

    public $SingularName = 'کاربر';
    public $PluralName = 'کاربران';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کامل'),
                                                                    HtmlTags::Th('شماره موبایل'),
                                                                    HtmlTags::Th('استان / شهر'),
                                                                    HtmlTags::Th('تاریخ ثبت نام'),
                                                                    HtmlTags::Th('کیف پول'),
                                                                    HtmlTags::Th('تعداد تراکنش های موفق'),
                                                                    HtmlTags::Th('ناریخ آخرین بازدید از اپلیکیشن'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function ($item) {
                                                                        $a = \model\Users::get($item);
                                                                        return $a->user_firstname . ' ' . $a->user_lastname;
                                                                    },
                                                                    'user_mobile',
                                                                    function ($item) {
                                                                        $state = \model\States::get($item->state_id)->state_name;
                                                                        $city = \model\Cities::get($item->city_id)->city_name;
                                                                        return $state . ' / ' . $city;
                                                                    },
                                                                    'register' => function ($item) {
                                                                        return jdate("Y/m/d", $item);
                                                                    },
                                                                    'price_format' => 'user_credit',
                                                                    function ($item) {
                                                                        $userId = $item->user_id;
                                                                        $payments = \model\PaymentTable::getAllConditioned("user_id = $userId AND payment_status = 1");
                                                                        return count($payments);
                                                                    },
                                                                    'login_date' => function ($item) {
                                                                        if ($item) {
                                                                            return jdate("Y/m/d", $item);
                                                                        } else {
                                                                            return "بدون بازدید";
                                                                        }
                                                                    }
                                                                ], true, true, false, false, function ($row) {
                                                                    if ($row->firebase_token) {
                                                                        return HtmlTags::Button('.btn.btn-outline-primary.m-2.p-2.sendNotif')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Envelope()),
                                                                        )->Data_('id', $row->user_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('ارسال نوتیفیکیشن');
                                                                    }
                                                                    return "";
                                                                }, function ($value) {
                                                                    return HtmlTags::Button('.btn.btn-outline-warning.m-2.p-2.sendSMS')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Envelope())
                                                                    )->Data_('mobile', $value->user_mobile)->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Title('ارسال اس ام اس');
                                                                }, function ($value) {
                                                                    return HtmlTags::Button('.btn.btn-outline-dark.m-2.p-2.walletCharge')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Money())
                                                                    )->Data_('id', $value->user_id)->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Title('شارژ کیف پول');
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات هویتی ') .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('user_firstname') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام خانوادگی') .
                                        $this->Html()->Input('user_lastname') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('شماره موبایل') .
                                        $this->Html()->Mobile('user_mobile') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('تاریخ تولد') .
                                        $this->Html()->Date('birthdate') .
                                        $this->Html()->FormGroupEnd() .


                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات جغرافیایی ') .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('انتخاب استان') .
                                        $this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('انتخاب شهر') .
                                        $this->Html()->Select('city_id', 'city_id', \model\Cities::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('آدرس منزل (اختیاری)') .
                                        $this->Html()->TextArea('address', 'address') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات حساب کاربری ') .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('رمز عبور') .
                                        $this->Html()->Password('user_password') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر پروفایل (اختیاری)') .
                                        $this->Html()->ImageInput('user_avatar', 'image/*', '150', '150', 'true', 'user_picture', false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کیف پول') .
                                        $this->Html()->Price('user_credit', 'user_credit', 'تومان', '0') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
