<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use FwHtml\FontAwesome;
use model\Entity\MoviesEntity;
use model\Entity\SerialsEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class UsersTable extends View
{

    public $SingularName = 'کاربر';
    public $PluralName = 'کاربران پنل';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd(),
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کاربری'),
                                                                    HtmlTags::Th('نام کاربر'),
                                                                    HtmlTags::Th('نقش'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    "user_username",
                                                                    "user_name",
                                                                    'role_name' => function ($item) {
                                                                        switch ($item) {
                                                                            case "AdminRole" :
                                                                                return "ادمین اصلی";
                                                                                break;
                                                                            case "OperatorRole" :
                                                                                return "اپراتور";
                                                                                break;
                                                                            case "SupervisorRole" :
                                                                                return "سوپروایزر";
                                                                                break;
                                                                            default;
                                                                                return "نامشخص";
                                                                                break;
                                                                        }
                                                                    },
                                                                    'user_status' => function($item){
                                                                        return $item == 1 ?HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                            "فعال"
                                                                        ):HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                            "غیر فعال"
                                                                        );


                                                                    }
                                                                ],true,true,false,false,function ($item){
                                                                    if ($item->role_name == "OperatorRole"){
                                                                        if ($item->user_status == '1'){
                                                                            return HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.deActiveUser')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                            )->Data_('id', $item->user_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('تعلیق اپراتور');
                                                                        }else{
                                                                            return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.activeUser')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                            )->Data_('id', $item->user_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('رفع تعلیق اپراتور');
                                                                        }
                                                                    }else{
                                                                        return "";
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form(): string
    {
        $userRole = UserObject::instance()->getRole();
        if ($userRole=="AdminRole"){
            $roles = HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید').
                HtmlTags::Option()->Value('AdminRole')->Content('ادمین اصلی').
                HtmlTags::Option()->Value('OperatorRole')->Content('اپراتور').
                HtmlTags::Option()->Value('SupervisorRole')->Content('سوپروایزر');
        }else{
            $roles = HtmlTags::Option()->Value('OperatorRole')->Content('اپراتور');

        }

        if ($userRole=="AdminRole"){
            $supervisors = \model\UsersTable::getAllFiltered('role_name',"SupervisorRole");
            $output=[HtmlTags::Option()->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید")];
            foreach ($supervisors as $item){
                $output[]=HtmlTags::Option()->Value($item->user_id)->Content($item->user_name." (".$item->user_username.")");
            }
            $selectBoxSupervisors = implode('.',$output);
        }else{
            $supervisorId = UserObject::instance()->getUserId();
            $supervisor = \model\UsersTable::get($supervisorId);
            $selectBoxSupervisors = HtmlTags::Option()->Selected()->Value($supervisorId)->Content($supervisor->user_name." (".$supervisor->user_username.")");
        }




        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام کاربری') .
                                        $this->Html()->Input('user_username') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('رمز عبور') .
                                        $this->Html()->Password('user_password') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام کاربر') .
                                        $this->Html()->Input('user_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('ایمیل') .
                                        $this->Html()->Email('user_email') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر پروفایل') .
                                        $this->Html()->ImageInput('user_profile','image/*','150','150',false,'user_profile',false) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('نقش') .
                                        $this->Html()->Select('role_name', 'role_name',
                                            $roles
                                        ) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'state_id d-none') .
                                        $this->Html()->Label('استان های مجاز به فعالیت') .
                                        $this->Html()->Select('state_ids[]', 'state_ids',HtmlTags::Option()->Selected()->Value(0)->Content('همه استان ها').\model\States::toOption(),true
                                        ) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'city_id d-none') .
                                        $this->Html()->Label('شهر های مجاز به فعالیت') .
                                        $this->Html()->Select('city_ids[]', 'city_ids',HtmlTags::Option()->Selected()->Value(0)->Content('همه شهر ها').\model\Cities::toOption(),true
                                        ) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4,'supervisor d-none') .
                                        $this->Html()->Label('انتخاب سوپروایزر سرپرست') .
                                        $this->Html()->Select('supervisor_id', 'supervisor_id',$selectBoxSupervisors).
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3,'service_id d-none') .
                                        $this->Html()->Label('خدمات مجاز به سفارش گیری') .
                                        $this->Html()->Select('service_ids[]', 'service_ids',HtmlTags::Option()->Selected()->Value(0)->Content('همه خدمات').\model\Services::toOption(),true
                                        ) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3,'credit_card d-none') .
                                        $this->Html()->Label('شماره کارت اپراتور') .
                                        $this->Html()->Number('user_credit_card', 'user_credit_card').
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3,'card_name d-none') .
                                        $this->Html()->Label('به نام') .
                                        $this->Html()->Input('user_card_name', 'user_card_name').
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3,'percent_share d-none') .
                                        $this->Html()->Label('درصد سهم از درآمد مجموعه') .
                                        $this->Html()->Percent('percentage_share', 'percentage_share','0').
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
